<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Dashboard extends CI_Controller {

	function __construct()
	{
		parent:: __construct();
		$this->load->model('login_model');
	}
	
	public function index()
	{		
		$this->load->view('external/index');
	}
	
	public function welcome()
	{
		$this->login_model->authenticate();
		$user_id = $this->login_model->user_id();
			
		$topbar_data['additional_css'] = array(NULL);
		$topbar_data['profile_photo'] = $this->main_model->create_thumbnail(160,160,$user_id);
		$sidebar_data['menu'] = $this->menu_control->get_menu($user_id);
		
		$jquery_data['additional_jquery'] = array(NULL);
		$jquery_data['functions'] = array(NULL);
		
		$this->load->view('sections/topbar',$topbar_data);
		$this->load->view('sections/sidebar',$sidebar_data);
		$this->load->view('sections/content');
		$this->load->view('sections/footer',$jquery_data);
	}
	
	function displayLoginForm()
	{
		$this->session->sess_destroy();
		$data = array('message' =>'');
		$this->load->view('external/login',$data);	
	}
	
	function login(){
		$national_id_no = $this->security->xss_clean($this->input->post('national_id_no'));
        $password = $this->security->xss_clean($this->input->post('password'));
		
		$response = $this->login_model->login($national_id_no,$password);
		
		if($response==true)
			{
				//redirect('user_management/member_registration');
				$this->welcome();
			}
		
		else if($response == 0)
			{
				$this->deactivated_account();
			} 
			
		else 
			{
				redirect('dashboard/fail');
			}
		}	
		
	function fail(){
		$this->session->sess_destroy();
		$data = array('message' =>' Wrong Login and/or password');
		$this->load->view('external/login',$data);
		}
	
	//user tries to access system with expired session data	
	function unauthorised(){
		$this->session->sess_destroy();
		$data = array('message' =>'Access Denied! (login to access the system)');
		$this->load->view('external/login',$data);
		}
	
	//function called if the account has been deactivated	
	function deactivated_account(){
		//$this->session->sess_destroy();
		$data = array('message' =>'Your account has been deactivated. Contact Admin.');
		$this->load->view('external/login',$data);
		}
		
	//this function is used when a user has more than one account in the system; same id_no(same pwd/diff pwd??)
	function multiple_accounts()
	{
		
	}		
	
	function logout()
	{
		$this->session->sess_destroy();
		//redirect('dashboard/index');	
		$this->index();
	}
		
}
